/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String TAG_BUILDING_SINGLE = "building-single";
    private final int buildingLevel;
    private final String building;
    private final boolean singleBuilding;

    public BuildingResearchRequirement(int buildingLevel, String building, boolean singleBuilding) {
        this.buildingLevel = buildingLevel;
        this.building = building;
        this.singleBuilding = singleBuilding;
    }

    public BuildingResearchRequirement(CompoundNBT nbt) {
        this.buildingLevel = nbt.func_74762_e(TAG_BUILDING_LVL);
        this.building = nbt.func_74779_i(TAG_BUILDING_NAME);
        this.singleBuilding = nbt.func_74767_n(TAG_BUILDING_SINGLE);
    }

    public String getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.hasBuilding(this.building, this.buildingLevel, this.singleBuilding);
    }

    @Override
    public TranslationTextComponent getDesc() {
        if (this.singleBuilding) {
            return new TranslationTextComponent("com.minecolonies.coremod.research.requirement.building.mandatory.level", new Object[]{new TranslationTextComponent("block.minecolonies.blockhut" + this.building), this.buildingLevel});
        }
        return new TranslationTextComponent("com.minecolonies.coremod.research.requirement.building.level", new Object[]{new TranslationTextComponent("block.minecolonies.blockhut" + this.building), this.buildingLevel});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return ModResearchRequirements.buildingResearchRequirement;
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(TAG_BUILDING_NAME, this.building);
        nbt.func_74768_a(TAG_BUILDING_LVL, this.buildingLevel);
        nbt.func_74757_a(TAG_BUILDING_SINGLE, this.singleBuilding);
        return nbt;
    }
}

